include <BOSL2/std.scad>

camera_bag_dimensions = [95,220,95]; //mm // reverse the order of x and y coordinates for snapping in the opposite direction
divisions = [1,3];
snap_margin = 10; // mm
current_axis = 1; // 0 for x and 1 for y
thickness = 2; // mm
tolerance = 1; // mm



if (current_axis == 0) {
    difference(){
        cuboid([camera_bag_dimensions.x+snap_margin*2,thickness,camera_bag_dimensions.z],anchor=BOTTOM+LEFT+FRONT);
        for (i = [0:divisions.x]){
        translate([snap_margin+camera_bag_dimensions.x/divisions.x*i-thickness/2-tolerance,0,camera_bag_dimensions.z/2]) cuboid([thickness+tolerance*2,thickness,camera_bag_dimensions.z/2],anchor=BOTTOM+LEFT+FRONT);
            }
    }
} else {
    difference(){
        cuboid([camera_bag_dimensions.y,thickness,camera_bag_dimensions.z],anchor=BOTTOM+LEFT+FRONT);
        for (i = [1:divisions.y-1]){
        translate([camera_bag_dimensions.y/(divisions.y)*i-thickness/2-tolerance,0,camera_bag_dimensions.z/2]) cuboid([thickness+tolerance*2,thickness,camera_bag_dimensions.z/2],anchor=BOTTOM+LEFT+FRONT);
            }
    }
}